/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.io.cache;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import org.jetbrains.annotations.NotNull;

public class FixedSizeSet<E>
implements Set<E> {
    private final List<E> backing = new LinkedList();
    private final int size;

    public FixedSizeSet(int size) {
        this.size = size;
    }

    @Override
    public int size() {
        return this.backing.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.backing.contains(o);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.backing.iterator();
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.backing.toArray();
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] ts) {
        return this.backing.toArray(ts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        List<E> list = this.backing;
        synchronized (list) {
            if (this.backing.contains(e)) {
                return false;
            }
            if (this.size() >= this.size) {
                this.backing.remove(0);
            }
            return this.backing.add(e);
        }
    }

    @Override
    public boolean remove(Object o) {
        return this.backing.remove(o);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        for (Object o : Objects.requireNonNull(collection)) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(@NotNull Collection<? extends E> collection) {
        List<E> list = this.backing;
        synchronized (list) {
            boolean result = false;
            for (E e : collection) {
                result |= this.add(e);
            }
            return result;
        }
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> collection) {
        return this.backing.retainAll(collection);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> collection) {
        return this.backing.removeAll(collection);
    }

    @Override
    public void clear() {
        this.backing.clear();
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.backing.spliterator();
    }

    public String toString() {
        return this.backing.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Set)) {
            return false;
        }
        Set s = (Set)obj;
        if (s.size() != this.size()) {
            return false;
        }
        return this.containsAll(s);
    }

    @Override
    public int hashCode() {
        return this.backing.hashCode();
    }
}

